﻿using Microsoft.Crm.Sdk.Messages;
using Microsoft.Xrm.Sdk;
using System.Collections.Generic;
using System.Threading.Tasks;

namespace VA.PPMS.IWS.MappingService.Interface
{
    public interface IMapper
    {
        Task<Entity> MapInsert<T>(T entity, Entity parent);

        Task<Entity> MapUpdate<T>(T entity, Entity parent);

        void AddChildrenToProvider(IList<Entity> entities, Entity parent);

        IEnumerable<SetStateRequest> MapDelete<T>(IList<T> entities, Entity parent);
    }
}